<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

require_once 'db.php'; // Your database connection file with $conn object

$response = [
    'status' => 'error',
    'message' => '',
    'data' => null
];

try {
    // Check if database connection exists
    if (!isset($conn) || !$conn) {
        throw new Exception('Database connection failed');
    }

    // Query to get the latest YouTube link (single record)
    $sql = "SELECT link FROM youtubelink ORDER BY id DESC LIMIT 1";
    $result = $conn->query($sql);

    if (!$result) {
        throw new Exception('Database query error: ' . $conn->error);
    }

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $response['status'] = 'success';
        $response['data'] = [
            'youtubeLink' => $row['link']
        ];
    } else {
        $response['message'] = 'No YouTube links found';
    }

    $result->close();
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
} finally {
    echo json_encode($response);
    if (isset($conn)) $conn->close();
}
?>